<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class LoginNotification extends Notification implements ShouldQueue
{
    use Queueable;

    protected $data;

    public function __construct($data)
    {
        $this->data = $data;
    }

    public function via($notifiable)
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        $ip = $this->data['ip'];
        $time = $this->data['time'];
        $device = $this->data['device'];

        return (new MailMessage)
            ->subject('Login Notification')
            ->line('You have logged in to your account.')
            ->line("IP Address: $ip")
            ->line("Time: $time")
            ->line("Device: $device")
            ->line('If this was not you, please contact us immediately.');
    }
}
